﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Web;
using VIA = VIRP_WEB.ViaServices;

namespace VIRP_WEB.BaseCode
{
    [Serializable()]
    public class NotesManager
    {
        private static VIA.ViaServices services = new VIA.ViaServices();

        public static readonly string LookupStationCode = "000";

        private ViaServiceData viaData;

        public ViaServiceData ViaData
        {
            get
            {
                if (this.viaData == null)
                    this.viaData = HttpContext.Current.Session["CprsSession"] as ViaServiceData;

                return this.viaData;
            }
            set
            {
                this.viaData = value;
                HttpContext.Current.Session["CprsSession"] = this.viaData;
            }
        }

        #region VIA Variable Declarations

        //private TbiServiceInterfaceClient _VIAService;
        private VIA.ViaPerson personsTOVIA;

        protected string loginSiteCode = null;
        private string userID = String.Empty;
        private string tokenizedDUZ = String.Empty;
        private string localPid = String.Empty;
        private string providerName = String.Empty;

        //DNS   BLANCT - unused field
        //private string savedItemID = String.Empty;

        #endregion

        public NotesManager()
        {
            if (this.viaData == null)
                this.viaData = HttpContext.Current.Session["CprsSession"] as ViaServiceData;
        }

        //public ViaServiceData GetViaData()
        //{
        //    ViaServiceData viaData = null;

        //    viaData = this.GetViaDataFromSession();
            
        //    return viaData;
        //}

        //public ViaServiceData GetViaDataFromSession()
        //{
        //    return HttpContext.Current.Session["ViaData"] as ViaServiceData;
        //}

        //public void AddToSessionViaData(ViaServiceData viaData)
        //{
        //    if (HttpContext.Current.Session["ConfirmedSSN"] != null)
        //    {
        //        if (HttpContext.Current.Session["ConfirmedSSN"].ToString() != viaData.PatientSnum)
        //        {
        //            //Logging.WriteLogToFile("BaseTBIInstrumentPage.AddtoSessionTBIServiceTo(): WarningRedirect: SSN Mismatch");
        //            //corrupted application context display error message to user
        //            HttpContext.Current.Response.Redirect("Warning.aspx?err=11");
        //        }
        //    }

        //    HttpContext.Current.Session["ViaData"] = viaData;
        //}

        public void PatientCprsLoad()
        {
            this.CheckNeedStationDivision();
            HttpContext.Current.Response.Cache.SetExpires(DateTime.Now);
            bool isCPRSLaunced = false;

            //if (_notesManager == null) { _notesManager = new InstrumentsManager(); }
            //TBIServiceTO _tbiServiceTo = GetTBIServiceTo();

            if (this.viaData == null)
            {
                //Logging.WriteLogToFile("BaseTBIInstrumentPage.PageLoad(): WarningRedirect: _tbiServiceTo is null");
                HttpContext.Current.Response.Redirect("Warning.aspx?err=2", true);
            }

            try
            {
                isCPRSLaunced = this.LoadViaData(this.viaData);
            }
            catch (Exception x)
            {
                isCPRSLaunced = false;
                throw x;
            }
            //if (!isCPRSLaunced)
            //{
            //    //throw new Exception("CPRS needs to be launched.");
            //    //Logging.WriteLogToFile("BaseTBIInstrumentPage.PageLoad(): WarningRedirect: VIA !_isCPRSLaunced");
            //    //Response.Redirect("Warning.aspx?err=12345", true);
            //}

            //this.AddToSessionViaData(this.viaData);
            //AddtoViewStateTBIServiceTo(_tbiServiceTo);
        }
        
        private VIA.ViaPerson CPRSLaunchVIA(string CURRENT_USER, ViaServiceData viaData)
        {
            //VIA.personsTO result = null;
            VIA.ViaPerson result = null;

            //*** DO NOT OVERRIDE THE loginSiteCode IN THIS METHOD
            try
            {
                this.userID = viaData.DUZ;
                this.localPid = viaData.DFN;
                //ProviderDFN update
                //HttpContext.Current.Session["ProviderDFN"] = this.localPid;
                this.ViaData.ProviderDFN = this.localPid;

                // We want to use the value we saved in the session UNLESS
                // the site code has changed (this happens when TBI can't determine the users
                // site and they select it from the pick-list provided
                //if (HttpContext.Current.Session["_VIAService.cprsLaunch"] == null ||
                //    HttpContext.Current.Session["_loginSiteCode"] == null ||
                //    loginSiteCode != Convert.ToString(HttpContext.Current.Session["_loginSiteCode"]))
                //{
                result = services.CPRSLaunch(CURRENT_USER, this.userID, this.localPid, this.loginSiteCode);
                //CprsLaunch update
                //HttpContext.Current.Session["_VIAService.cprsLaunch"] = result;
                this.ViaData.VIAServiceCprsLaunch = result;

                //LoginSiteCode update
                //HttpContext.Current.Session["_loginSiteCode"] = this.loginSiteCode;
                this.ViaData.LoginSiteCode = this.loginSiteCode;

                //}
                //else
                //{
                //    result = GetPersonTOFromSession();
                //}
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw ex;
            }

            return result;
        }

        #region VIA Service Methods

        public bool LoadViaData()
        {
            try
            {
                string error = string.Empty;
                //DO NOT GET THIS//textTO textSiteId = getSiteIdVIA(tbiServiceTo.ServerIP, out error);
                if (error == "SUCCESS") { error = null; }

                if (!string.IsNullOrEmpty(error))
                {
                    return false;
                }
                else
                {
                    if (null != this.viaData && !string.IsNullOrEmpty(this.viaData.SiteCode))
                    {
                        if (!string.IsNullOrEmpty(this.StationDivision))
                            this.loginSiteCode = this.viaData.SiteCode = this.StationDivision;
                        else
                            this.loginSiteCode = this.viaData.SiteCode;
                    }

                    this.personsTOVIA = this.CPRSLaunchVIA(HttpContext.Current.User.Identity.Name, this.viaData);

                    if (this.personsTOVIA == null || this.personsTOVIA.Fault != null)
                    {
                        //Logging.WriteLogToFile("LoadViaData: _personsTOVIA null or has fault");
                        this.ViaData = null;
                    }

                    if (this.viaData != null)
                    {
                        if (this.personsTOVIA != null)
                        {
                            this.viaData.StationNumber = this.loginSiteCode;
                            this.viaData.PatientName = this.personsTOVIA.PatientName;
                            this.viaData.PatientDOB = this.personsTOVIA.PatientDob;
                            this.viaData.PatientGender = this.personsTOVIA.PatientGender;
                            this.viaData.PatientSnum = this.personsTOVIA.PatientSnum;
                            this.viaData.PatientICN = this.personsTOVIA.MpiPid;
                            this.viaData.PatientDFN = this.personsTOVIA.LocalPid;
                            this.viaData.PatientAdmitTimeStamp = this.personsTOVIA.AdmitTimestamp;

                            this.viaData.STA6N = this.personsTOVIA.UserSiteId;
                            this.viaData.UserName = this.personsTOVIA.UserName;
                            this.providerName = this.personsTOVIA.UserName;
                            this.tokenizedDUZ = this.personsTOVIA.UserDuz;

                            //TokenizedDUZ update
                            //if (HttpContext.Current.Session["TokenizedDUZ"] == null)
                            //{
                            //    HttpContext.Current.Session["TokenizedDUZ"] = this.tokenizedDUZ;
                            //}
                            if (string.IsNullOrEmpty(this.viaData.TokenizedDUZ))
                            {
                                this.viaData.TokenizedDUZ = this.tokenizedDUZ;
                            }

                            //ProviderName update
                            //if (HttpContext.Current.Session["ProviderName"] == null)
                            //{
                            //    HttpContext.Current.Session["ProviderName"] = this.providerName;
                            //}
                            if (string.IsNullOrEmpty(this.viaData.ProviderName))
                            {
                                this.viaData.ProviderName = this.providerName;
                            }

                            this.viaData.PatientLocationId = this.personsTOVIA.LocationId;

                            this.viaData.InstitutionName = this.personsTOVIA.LocationFacilityName;
                        }
                    }

                    if (this.viaData == null)
                    {
                        return false;
                    }
                    else
                    {
                        return true;
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                return false;
            }
        }

        public bool LoadViaData(ViaServiceData viaData)
        {
            this.ViaData = viaData;
            return this.LoadViaData();
        }

        /// <summary>
        /// VIA: getNoteTitlesFromVIA service method
        /// </summary>
        /// <param name="target"></param>
        /// <param name="direction"></param>
        /// <param name="error"></param>
        /// <returns></returns>
        public List<VIA.StringKeyValuePair> GetNoteTitlesFromVIA(string target, string direction, out string error)
        {
            try
            {
                if (!string.IsNullOrEmpty(this.StationDivision))
                    this.ViaData.StationNumber = this.StationDivision;
                this.loginSiteCode = this.ViaData.StationNumber;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw;
            }

            //ProviderDFN update
            var result = services.GetNoteTitles(HttpContext.Current.User.Identity.Name, target, direction, this.loginSiteCode, this.ViaData.ProviderDFN, this.ViaData.TokenizedDUZ, this.ViaData.ProviderName, out error);

            return result.ToList();
        }

        public List<VIA.StringKeyValuePair> GetConsultsFromVIA(out string error)
        {
            try
            {
                if (!string.IsNullOrEmpty(this.StationDivision))
                    this.ViaData.StationNumber = this.StationDivision;
                this.loginSiteCode = this.ViaData.StationNumber;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw;
            }

            //ProviderDFN update
            var result2 = services.GetConsults(HttpContext.Current.User.Identity.Name, this.loginSiteCode, this.ViaData.ProviderDFN, this.ViaData.ProviderName, this.ViaData.TokenizedDUZ, out error);
            return result2.ToList();
        }

        public List<VIA.StringKeyValuePair> GetHospitalAdmissionsFromVIA(out string error)
        {
            try
            {
                if (!string.IsNullOrEmpty(this.StationDivision))
                    this.ViaData.StationNumber = this.StationDivision;
                this.loginSiteCode = this.ViaData.StationNumber;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw;
            }

            //ProviderDFN update
            var result2 = services.GetHospitalAdmissions(HttpContext.Current.User.Identity.Name, this.loginSiteCode, this.ViaData.ProviderDFN, this.ViaData.ProviderName, this.ViaData.TokenizedDUZ, this.ViaData.PatientICN, out error);

            return result2.ToList();
        }

        public List<VIA.StringKeyValuePair> GetVisitsFromVIA(DateTime fromDate, DateTime toDate, out string error)
        {
            string formattedFromDate = this.FormatDateForVIA(fromDate);
            string formattedToDate = this.FormatDateForVIA(toDate);

            try
            {
                if (!string.IsNullOrEmpty(this.StationDivision))
                    this.ViaData.StationNumber = this.StationDivision;
                this.loginSiteCode = this.ViaData.StationNumber;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw;
            }

            //ProviderDFN update
            var result2 = services.GetVisits(HttpContext.Current.User.Identity.Name, fromDate, toDate, this.loginSiteCode, this.ViaData.ProviderDFN, this.ViaData.ProviderName, this.ViaData.TokenizedDUZ, this.ViaData.PatientICN, out error);

            return result2.ToList();
        }

        public List<VIA.StringKeyValuePair> GetLocationsFromVIA(string searchParameter, string direction, out string error)
        {
            try
            {
                if (!string.IsNullOrEmpty(this.StationDivision))
                    this.ViaData.StationNumber = this.StationDivision;
                this.loginSiteCode = this.ViaData.StationNumber;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw;
            }

            //ProviderDFN update
            var result2 = services.GetLocations(HttpContext.Current.User.Identity.Name, searchParameter, direction, this.loginSiteCode, this.ViaData.ProviderDFN, this.ViaData.ProviderName, this.ViaData.TokenizedDUZ, out error);

            return result2.ToList();
        }

        public void WriteNoteWithVIA()
        {
            //VIA.noteResultTO writeNoteResult = new VIA.noteResultTO();
            //textTO _closeNoteResult = null;
            string titleIEN = "";
            string encounterString = "";
            string noteText = "";
            string authorDUZ = "";
            string cosignerDUZ = "";
            string consultIEN = "";
            string prfIEN = "";

            //set the values for the writeNote web service based on the noteType
            switch (this.viaData.SelectedNoteType.Id)
            {
                case (int)NoteTypeEnum.ScheduledClinicAppointment:  //Scheduled Clinic Appointment
                    //if the note is for current visit or previous visit, call getVisits and have the user pick one . 
                    //Then encounterString = visit.location.id + ‘;’ + visit.timestamp + ‘;A’ 

                    //already formated when list box data items are created
                    encounterString = this.viaData.SelectedVisitId;
                    break;
                case (int)NoteTypeEnum.HospitalAdmission:  //Hospital Admission
                    //if the note is for previous stay, call getAdmissions and have the user pick one. 
                    //Then encounterString = stay.location.id + ‘;’ + stay.admitTimestamp + ‘;H’ 

                    //already formated when list box data items are created
                    encounterString = this.viaData.SelectedHospitalAdmissionId;
                    break;
                case (int)NoteTypeEnum.CurrentStay:  //Current Stay
                    //if the note is for current stay, encounterString = patient.locationId + ‘;’ + patient.admitTimestamp + ‘;H’ -- needs conversion to Fileman date
                    encounterString = this.viaData.PatientLocationId + ";" + this.FormatDateForVIA2(DateTime.ParseExact(this.viaData.PatientAdmitTimeStamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture)) + ";H";
                    break;
                case (int)NoteTypeEnum.UnscheduledOrNewVisit: //Unscheduled or New Visit

                    if (!this.viaData.IsHistorical)
                    {
                        //if the note is for a new visit, but not hisorical, call getLocations and have the user pick one. 
                        //Then encounterString = location.id + ‘;’ + 20080515.1500 (today's date) + ‘;A’ 
                        encounterString = this.viaData.SelectedLocationID + ";" + this.FormatDateForVIA2(DateTime.Now) + ";A";
                    }
                    else
                    {
                        //if the note is for a new visit, and is historical, 
                        //then previous step but end with ‘;E’ instead of ‘;A’. 
                        encounterString = this.viaData.SelectedLocationID + ";" + FormatDateForVIA2(DateTime.Now) + ";E";
                    }
                    break;
            }

            //For preserving line breaks within a text block that is being written to a note, replace the \r\n or \n characters with a pipe (|).
            noteText = this.viaData.NoteText.Replace("<br>", "|").Replace(Environment.NewLine, "|").Replace("\v", "|");

            authorDUZ = this.viaData.DUZ;

            if (!String.IsNullOrEmpty(this.viaData.SelectedConsultId))
            {
                consultIEN = this.viaData.SelectedConsultId;
            }

            if (this.viaData.SelectedNoteTitleId != "" && this.viaData.SelectedNoteTitleId != null)
            {
                titleIEN = this.viaData.SelectedNoteTitleId;
            }
            //titleIEN = "1572";

            if (!String.IsNullOrEmpty(this.viaData.SelectedCosignerID))
            {
                cosignerDUZ = this.viaData.SelectedCosignerID;
            }

            prfIEN = "";

            //bool savedFlag = false;
            //ProviderDFN update
            services.WriteNote(HttpContext.Current.User.Identity.Name, titleIEN, encounterString, noteText, authorDUZ, cosignerDUZ, consultIEN, prfIEN, this.loginSiteCode, this.ViaData.ProviderDFN, this.ViaData.ProviderName, this.ViaData.TokenizedDUZ);
        }

        public void WriteNoteWithVIA(ViaServiceData viaData)
        {
            this.ViaData = viaData;
            this.WriteNoteWithVIA();
        }

        /// <summary>
        /// VIA: CloseNote service method call
        /// </summary>
        /// <param name="noteIEN"></param>
        /// <param name="consultIEN"></param>
        /// <returns></returns>
        //private textTO CloseNoteWithVIA(string noteIEN, string consultIEN)
        //{
        //    textTO result = null;

        //    MDWSLog mdwsLog = new MDWSLog();
        //    MDWS_LOG _mdwsLog = new MDWS_LOG();
        //    _cprsManager.SetMDWSLogDefaults(ref _mdwsLog);
        //    _mdwsLog.SERVICE_NAME = "closeNoteVIA";
        //    _mdwsLog.PARAMETERS = _cprsManager.xmlParameters(new string[] { noteIEN, consultIEN });

        //    try
        //    {
        //        queryBean bean = new queryBean();
        //        patient patientbean = new patient();
        //        provider providerbean = new provider();
        //        if (!string.IsNullOrEmpty(StationDivision))
        //            this.TbiServiceTo.StationNumber = StationDivision;
        //        loginSiteCode = this.TbiServiceTo.StationNumber;

        //        bean.requestingApp = Helpers.GetDBConfigEntry("TBIServiceRequestingApp"); //"TBI";
        //        bean.consumingAppToken = Helpers.GetDBConfigEntry("TBIServiceCred1");
        //        bean.consumingAppPassword = Helpers.GetDBConfigEntry("TBIServiceCred2");
        //        bean.recordSiteCode = loginSiteCode;
        //        providerbean.userId = HttpContext.Current.Session["TokenizedDUZ"].ToString();
        //        bean.provider = providerbean;

        //        result = _VIAService.closeNote(noteIEN, consultIEN, bean);

        //        if (result != null)
        //        {
        //            if (LogFullVIAResponse)
        //                _mdwsLog.RETURNED_DATA = result.Serialize();
        //            else
        //                _mdwsLog.RETURNED_DATA = (null == result) ? "No Result" : "Valid Result";

        //            if (result.fault != null)
        //            {
        //                _mdwsLog.ERROR_LEVEL = 0;
        //            }
        //        }
        //        else
        //        {
        //            _mdwsLog.ERROR_LEVEL = 1;
        //        }
        //    }
        //    catch (Exception exc)
        //    {
        //        Helpers.HandleTBIException(exc, "InstrumentManager.cs", "", "CloseNoteWithVIA()");
        //        _mdwsLog.ERROR_LEVEL = 2;
        //    }

        //    mdwsLog.LogMDWSCall(_mdwsLog);

        //    return result;
        //}

        ///// <summary>
        ///// VIA: isCosignerRequired service method call
        ///// </summary>
        ///// <param name="tbiServiceTO"></param>
        ///// <param name="errMsg"></param>
        ///// <returns></returns>
        //public bool isCosignerRequiredVIA(TBIServiceTO tbiServiceTO, out string errMsg)
        //{
        //    bool ret = false;
        //    textTO result = null;
        //    string noteDefinitionIEN = "";
        //    string authorDUZ = "";

        //    errMsg = "Service isCosignerRequiredVIA returned NULL value"; //Default error message

        //    noteDefinitionIEN = tbiServiceTO.SelectedNoteTitleId;
        //    authorDUZ = tbiServiceTO.DUZ;
        //    if (!string.IsNullOrEmpty(StationDivision))
        //        tbiServiceTO.StationNumber = StationDivision;
        //    loginSiteCode = tbiServiceTO.StationNumber;

        //    MDWSLog mdwsLog = new MDWSLog();
        //    MDWS_LOG _mdwsLog = new MDWS_LOG();
        //    _cprsManager.SetMDWSLogDefaults(ref _mdwsLog);
        //    _mdwsLog.SERVICE_NAME = "isCosignerRequiredVIA";
        //    _mdwsLog.PARAMETERS = _cprsManager.xmlParameters(new string[] { noteDefinitionIEN, authorDUZ });

        //    try
        //    {
        //        queryBean bean = new queryBean();
        //        patient patientbean = new patient();
        //        provider providerbean = new provider();

        //        bean.itemId = noteDefinitionIEN;
        //        bean.recordSiteCode = loginSiteCode;
        //        bean.requestingApp = Helpers.GetDBConfigEntry("TBIServiceRequestingApp"); //"TBI";
        //        bean.consumingAppToken = Helpers.GetDBConfigEntry("TBIServiceCred1");
        //        bean.consumingAppPassword = Helpers.GetDBConfigEntry("TBIServiceCred2");
        //        providerbean.name = HttpContext.Current.Session["ProviderName"].ToString();
        //        providerbean.loginSiteCode = loginSiteCode;
        //        providerbean.userId = HttpContext.Current.Session["TokenizedDUZ"].ToString();
        //        bean.criteria = authorDUZ;
        //        patientbean.mpiPid = tbiServiceTO.PatientICN;

        //        bean.patient = patientbean;
        //        bean.provider = providerbean;

        //        result = _VIAService.isCosignerRequired(bean);

        //        if (result != null)
        //        {
        //            if (LogFullVIAResponse)
        //                _mdwsLog.RETURNED_DATA = result.Serialize();
        //            else
        //                _mdwsLog.RETURNED_DATA = (null == result) ? "No Result" : "Valid Result";

        //            if (result.fault != null)
        //            {
        //                _mdwsLog.ERROR_LEVEL = 1;
        //                errMsg = result.fault.message;
        //            }
        //            else
        //            {
        //                _mdwsLog.ERROR_LEVEL = 0;
        //                errMsg = String.Empty;
        //            }
        //        }
        //        else
        //        {
        //            _mdwsLog.ERROR_LEVEL = 2;
        //        }
        //    }
        //    catch (Exception exc)
        //    {
        //        Helpers.HandleTBIException(exc, "InstrumentManager.cs", "", "isCosignerRequiredVIA()");
        //        _mdwsLog.ERROR_LEVEL = 2;
        //    }

        //    mdwsLog.LogMDWSCall(_mdwsLog);

        //    if (!String.IsNullOrEmpty(result.text))
        //    {
        //        switch (result.text.ToUpper())
        //        {
        //            case "Y":
        //                ret = true;
        //                break;
        //            case "N":
        //                break;
        //            default:
        //                errMsg = "VIA Service isCosignerRequiredVIA returned uexpected value " + result.text;
        //                break;
        //        }
        //    }

        //    return ret;
        //}

        //public string LookupSiteCodeByServer(string vistaServer, out string error)
        //{
        //    if (_VIAService == null)
        //    {
        //        _VIAService = CreateVIAClientFromDB();
        //        if (_VIAService == null)
        //            _VIAService = new TbiServiceInterfaceClient("TbiServiceImplPort");
        //    }
        //    textTO temp = getSiteIdVIA(vistaServer, out error);
        //    if (null != temp)
        //        return temp.text;
        //    return null;
        //}

        //public textTO getSiteIdVIA(string vistaServer, out string error)
        //{
        //    textTO result = null;

        //    try
        //    {
        //        //if (_notesManager == null) { _notesManager = new InstrumentsManager(); }
        //        TBIServiceTO _tbiServiceTo = System.Web.HttpContext.Current.Session["ViaData"] as TBIServiceTO;
        //        if (LoadViaData(_tbiServiceTo))
        //        {
        //            provider providerbean = new provider();
        //            patient patientbean = new patient();
        //            queryBean bean = new queryBean();

        //            //_userID = _tbiServiceTo.DUZ;
        //            _userID = HttpContext.Current.Session["TokenizedDUZ"].ToString();

        //            _localPid = _tbiServiceTo.DFN;
        //            HttpContext.Current.Session["ProviderDFN"] = _localPid;

        //            bean.criteria = "TBI_PWD";
        //            bean.requestingApp = Helpers.GetDBConfigEntry("TBIServiceRequestingApp"); //"TBI";
        //            bean.consumingAppToken = Helpers.GetDBConfigEntry("TBIServiceCred1");
        //            bean.consumingAppPassword = Helpers.GetDBConfigEntry("TBIServiceCred2");
        //            //patient attributes
        //            patientbean.localSiteId = loginSiteCode;
        //            patientbean.localPid = HttpContext.Current.Session["ProviderDFN"].ToString();
        //            bean.patient = patientbean;
        //            //provider attributes
        //            providerbean.loginSiteCode = loginSiteCode;
        //            providerbean.userId = _userID;
        //            bean.provider = providerbean;

        //            result = _VIAService.getSite(vistaServer, bean);    //.getSiteId(vistaServer);

        //            if (result != null)
        //            {
        //                if (LogFullVIAResponse)
        //                    _mdwsLog.RETURNED_DATA = result.Serialize();
        //                else
        //                    _mdwsLog.RETURNED_DATA = (null == result) ? "No Result" : "Valid Result";

        //                if (result.fault != null)
        //                {
        //                    _mdwsLog.ERROR_LEVEL = 1;
        //                    error = result.fault.message;
        //                }
        //                else
        //                {
        //                    _mdwsLog.ERROR_LEVEL = 0;
        //                    error = "SUCCESS";
        //                }
        //            }
        //            else
        //            {
        //                error = "VIA Service call getSiteId returned null";
        //                _mdwsLog.ERROR_LEVEL = 2;
        //            }
        //        }
        //        else
        //        {
        //            Logging.WriteLogToFile("LoadViaData(_tbiServiceTo): Failure response");
        //            error = "LoadViaData(_tbiServiceTo): Failure response";
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        Helpers.HandleTBIException(ex, "InstrumentManager.cs", "", "getSiteIdVIA()");
        //        error = ex.Message;
        //        _mdwsLog.ERROR_LEVEL = 2;
        //    }

        //    mdwsLog.LogMDWSCall(_mdwsLog);

        //    return result;
        //}

        /// <summary>
        /// VIA: FormatDateForVIA date formatting
        /// </summary>
        /// <param name="dateValue"></param>
        /// <returns></returns>
        private string FormatDateForVIA(DateTime dateValue)
        {
            // CPRS is expecting date in the following format "20000101.000000";
            //  [yyyy -1700]MMdd.HHmmss.  For example, 3130715.163242 represents the date and time of JUL 15, 2013 at 16:32:42
            //return String.Format("{0:yyyyMMdd}", dateValue);

            if (dateValue != null)
            {
                //return (dateValue.Year - 1700) + "" + dateValue.ToString("MM") + dateValue.ToString("dd") + "." + dateValue.ToString("HH") + dateValue.ToString("mm") + dateValue.ToString("ss");
                return dateValue.Year + "" + dateValue.ToString("MM") + dateValue.ToString("dd");
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// VIA: FormatDateForVIA date formatting
        /// </summary>
        /// <param name="dateValue"></param>
        /// <returns></returns>
        private string FormatDateForVIA2(DateTime dateValue)
        {
            // CPRS is expecting date in the following format "20000101.000000";
            //  [yyyy -1700]MMdd.HHmmss.  For example, 3130715.163242 represents the date and time of JUL 15, 2013 at 16:32:42
            //return String.Format("{0:yyyyMMdd}", dateValue);

            if (dateValue != null)
            {
                return (dateValue.Year - 1700) + "" + dateValue.ToString("MM") + dateValue.ToString("dd") + "." + dateValue.ToString("HH") + dateValue.ToString("mm") + dateValue.ToString("ss");
            }
            else
            {
                return null;
            }
        }

        #endregion

        #region CCOW

        private void CheckNeedStationDivision()
        {
            //DRL - uncomment this to skip the CCOW screen
            //StationDivision = "442";
            if (string.IsNullOrEmpty(this.StationDivision))
            {
                HttpContext.Current.Response.Redirect("StationDivisionAuthorization.aspx", true);
            }
        }

        private string StationDivision
        {
            get
            {
                //return System.Web.HttpContext.Current.Session["StationDivision"] as string;
                return this.viaData.SiteCode;
            }
        }

        #endregion CCOW

        public bool TestVIALogin(string CURRENT_USER, ViaServiceData viaData, out string error)
        {
            error = null;
            try
            {
                //DO NOT OVERIDE siteCode
                this.loginSiteCode = viaData.SiteCode;
                this.userID = viaData.DUZ;
                this.localPid = viaData.DFN;

                var temp = services.CPRSLaunch(CURRENT_USER, this.userID, this.localPid, this.loginSiteCode);
                if (temp == null)
                {
                    throw new NullReferenceException("No result returned from call to VIA service.");
                }
                if (temp.Fault != null && !string.IsNullOrEmpty(temp.Fault))
                {
                    throw new Exception(temp.Fault);
                }

                return true;
            }
            catch (Exception ex)
            {
                error = ex.Message;
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                return false;
            }
        }
    }

    public enum NoteTypeEnum : int
    {
        ScheduledClinicAppointment = 0,
        HospitalAdmission = 1,
        CurrentStay = 2,
        UnscheduledOrNewVisit = 3
    }
}